/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.BaseGoal;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class SummonMinionsGoal
extends BaseGoal {
    protected int summonTime = 0;
    protected int summonRate = 60;
    protected int summonCap = 5;
    protected CreatureInfo minionInfo;
    protected boolean perPlayer = false;
    protected boolean antiFlight = false;
    protected double sizeScale = 1.0;

    public SummonMinionsGoal(BaseCreatureEntity setHost) {
        super(setHost);
    }

    public SummonMinionsGoal setSummonRate(int summonRate) {
        this.summonRate = summonRate;
        return this;
    }

    public SummonMinionsGoal setSummonCap(int summonCap) {
        this.summonCap = summonCap;
        return this;
    }

    public SummonMinionsGoal setPerPlayer(boolean perPlayer) {
        this.perPlayer = perPlayer;
        return this;
    }

    public SummonMinionsGoal setAntiFlight(boolean antiFlight) {
        this.antiFlight = antiFlight;
        return this;
    }

    public SummonMinionsGoal setMinionInfo(String creatureName) {
        this.minionInfo = CreatureManager.getInstance().getCreature(creatureName);
        return this;
    }

    public SummonMinionsGoal setSizeScale(double sizeScale) {
        this.sizeScale = sizeScale;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        if (this.host.isPetType("familiar")) {
            return false;
        }
        return super.func_75250_a() && this.minionInfo != null;
    }

    public void func_75249_e() {
        this.summonTime = 1;
    }

    public void func_75246_d() {
        if (this.summonTime++ % this.summonRate != 0) {
            return;
        }
        if (this.host.getMinions(this.minionInfo.getEntityClass()).size() >= this.summonCap) {
            return;
        }
        if (this.antiFlight) {
            for (EntityPlayer target : this.host.playerTargets) {
                if (target.func_184812_l_() || target.func_175149_v() || !(CreatureManager.getInstance().config.bossAntiFlight > 0.0) || !(target.field_70163_u > this.host.field_70163_u + CreatureManager.getInstance().config.bossAntiFlight + 1.0)) continue;
                this.summonMinion((EntityLivingBase)target);
            }
            return;
        }
        this.summonMinion(this.host.func_70638_az());
    }

    protected void summonMinion(EntityLivingBase target) {
        EntityLiving minion = this.minionInfo.createEntity(this.host.func_130014_f_());
        this.host.summonMinion((EntityLivingBase)minion, this.host.func_70681_au().nextDouble() * 360.0, this.host.field_70130_N + 1.0f);
        if (minion instanceof BaseCreatureEntity) {
            BaseCreatureEntity minionCreature = (BaseCreatureEntity)minion;
            minionCreature.func_70624_b(target);
            minionCreature.setSizeScale(minionCreature.sizeScale * this.sizeScale);
        }
    }
}

